/*
 * Decompiled with CFR 0.152.
 */
package com.olziedev.playerwarps.uxmclaims;

import com.olziedev.playerwarps.api.expansion.WAddon;
import com.olziedev.playerwarps.api.player.WPlayer;
import com.olziedev.playerwarps.api.warp.WLocation;
import com.olziedev.playerwarps.api.warp.WarpType;
import com.uxplima.claim.bukkit.api.UxmClaimBukkitAPI;
import com.uxplima.claim.bukkit.api.annotation.ClaimEventHandler;
import com.uxplima.claim.domain.event.ClaimCreateEvent;
import com.uxplima.claim.domain.event.ClaimDeleteEvent;
import com.uxplima.claim.domain.model.Claim;
import com.uxplima.claim.domain.model.vo.Location;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class UxmClaimsAddon
extends WAddon {
    public boolean isEnabled() {
        return Bukkit.getPluginManager().getPlugin("uxmClaims") != null && this.expansionConfig.getBoolean("addons.uxmclaims.enabled");
    }

    public String getName() {
        return "uxmClaims Addon";
    }

    public void onLoad() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.warpNameReplacement = this.expansionConfig.getString("addons.uxmclaims.warp-name-creation");
        UxmClaimBukkitAPI.getInstance().registerEvent((Object)this);
    }

    public void unload() {
        UxmClaimBukkitAPI.getInstance().unregisterEvent((Object)this);
    }

    public Runnable isAuthorized(Player player) {
        org.bukkit.Location location = player.getLocation();
        Claim claim = UxmClaimBukkitAPI.getInstance().claimFacade().getByLocation(new Location(location.getWorld().getName(), location.getX(), location.getY(), location.getZ()));
        if (claim == null) {
            if (!this.expansionConfig.getBoolean("addons.uxmclaims.only-land")) {
                return null;
            }
            return () -> this.api.sendMessage((CommandSender)player, this.expansionConfig.getString("addons.uxmclaims.lang.not-in-claim"));
        }
        boolean trustedPlayers = this.expansionConfig.getBoolean("addons.uxmClaims.trusted-members");
        if (player.getUniqueId().equals(claim.getOwnerUid()) || trustedPlayers && claim.getMembers().containsKey(player.getUniqueId())) {
            return null;
        }
        return () -> this.api.sendMessage((CommandSender)player, this.expansionConfig.getString("addons.uxmclaims.lang.dont-own-claim"));
    }

    @ClaimEventHandler
    public void onTownCreate(ClaimCreateEvent event) {
        if (!this.expansionConfig.getBoolean("addons.uxmclaims.create")) {
            return;
        }
        Claim claim = event.getClaim();
        WPlayer warpPlayer = this.api.getWarpPlayer(claim.getOwnerUid());
        Location spawnLocation = claim.getSpawnLocation();
        this.api.createPlayerWarp(this.warpNameReplacement.replace("%player%", warpPlayer.getName()), this.api.createWarpLocation(new org.bukkit.Location(Bukkit.getWorld((String)spawnLocation.getWorld()), spawnLocation.getX(), spawnLocation.getY(), spawnLocation.getZ())), warpPlayer, WarpType.NORMAL, (CommandSender)warpPlayer.getPlayer(), null);
    }

    @ClaimEventHandler
    public void onTownDisband(ClaimDeleteEvent event) {
        this.deleteTown(event.getClaim());
    }

    public void deleteTown(Claim oldClaim) {
        if (!this.expansionConfig.getBoolean("addons.uxmclaims.delete")) {
            return;
        }
        List uuids = oldClaim.getMembers().keySet().stream().map(x -> Bukkit.getOfflinePlayer((UUID)x).getUniqueId()).collect(Collectors.toList());
        uuids.add(oldClaim.getOwnerUid());
        uuids.stream().filter(Objects::nonNull).flatMap(uuid -> this.api.getWarpPlayer(uuid).getWarps(true).stream()).forEach(playerWarp -> {
            WLocation loc = playerWarp.getWarpLocation();
            if (loc == null) {
                return;
            }
            Claim claim = UxmClaimBukkitAPI.getInstance().claimFacade().getByLocation(new Location(loc.getWorld(), loc.getX(), loc.getY(), loc.getZ()));
            if (claim == null || !claim.equals(oldClaim)) {
                return;
            }
            playerWarp.removeWarp(false, (CommandSender)Bukkit.getConsoleSender());
        });
    }
}

