/*
 * MIT License
 *
 * Copyright (c) 2025 Olzie Development
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

package com.olziedev.olzieplugin.api;

import com.olziedev.olzieplugin.api.expansion.ExpansionRegistry;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

/**
 * Represents an API implementation that can be used to implement the API
 */
public interface PluginAPI {


    /**
     * @return The expansion registry to manage the plugin expansions.
     */
    ExpansionRegistry getExpansionRegistry();

    /**
     * Use the plugin send message method for all type of syntax support.
     *
     * @param sender The entity who will receive the message.
     * @param message The message.
     */
    void sendMessage(CommandSender sender, String message);

    /**
     * Use the plugin create item method for all type item creation support.
     *
     * @param section The configuration section to get the item from.
     * @param containsTag If the item contains a tag.
     * @return The item from the configuration section.
     */
    ItemStack createConfigItem(ConfigurationSection section, boolean containsTag);

    /**
     * @return The plugin instance.
     */
    OlziePluginAPI getPlugin();
}
