/*
 * MIT License
 *
 * Copyright (c) 2026 Olzie Development
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

package com.olziedev.olzieplugin.api.internal;

import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import org.bukkit.entity.Player;

import java.util.Collections;
import java.util.function.Predicate;

/**
 * This class is only to be supported with Paper's dialog API, and any of the adventure imports SHOULD NOT BE RELOCATED!
 */
public class DialogUtils {

    public static void openSearchDialog(Player player, Predicate<String[]> lines) {
        player.showDialog(Dialog.create(builder -> builder
                .empty().base(
                        DialogBase.builder(Component.text("Search"))
                                .body(Collections.singletonList(
                                        DialogBody.plainMessage(Component.text("Please enter text."))
                                ))
                                .inputs(Collections.singletonList(DialogInput.text("search", Component.text("Enter text"))
                                        .width(200)
                                        .initial("")
                                        .maxLength(128)
                                        .build()))
                                .build()
                )
                .type(DialogType.confirmation(
                        ActionButton.create(
                                Component.text("OK"),
                                null,
                                100,
                                DialogAction.customClick((view, audience) -> {
                                    String[] linesInput = new String[4];
                                    for (int i = 0; i < 4; i++) linesInput[i] = view.getText("search");

                                    lines.test(linesInput);
                                }, ClickCallback.Options.builder().uses(1).build())
                        ),
                        ActionButton.create(
                                Component.text("Cancel"),
                                null,
                                100,
                                null
                        )
                ))
        ));
    }
}
