/*
 * MIT License
 *
 * Copyright (c) 2024 Olzie Development
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

package com.olziedev.olzieplugin.api;

import com.olziedev.olzieplugin.api.expansion.ExpansionRegistry;
import com.olziedev.olzieplugin.api.scheduler.PluginScheduler;
import com.olziedev.olzieplugin.api.utils.LogLevel;
import org.bukkit.plugin.java.JavaPlugin;

/**
 * The main class for accessing and using the API.
 */
public abstract class OlziePluginAPI extends JavaPlugin {

    /**
     * @return The expansion manager.
     */
    public abstract ExpansionRegistry getExpansionRegistry();

    /**
     * @return The plugin scheduler.
     */
    public abstract PluginScheduler<?, ?> getPluginScheduler();

    /**
     * @return The class loader of the plugin.
     */
    public abstract ClassLoader getClazzLoader();

    /**
     * Debugs a message to the console, if debugging is enabled.
     *
     * @param message The message to debug.
     */
    public void debug(String message) {
        debug(message, LogLevel.MINOR);
    }

    /**
     * Debugs a message to the console, if debugging is enabled.
     *
     * @param message The message to debug.
     * @param logLevel The log level of the message.
     */
    public abstract void debug(String message, LogLevel logLevel);

    /**
     * Called when the plugin has finished loading.
     */
    protected abstract void onLoadComplete();
}
